/*
   Borland C++ Builder TExtOpenDialog and TExtSaveDialog components
   Version 1.0

   Copyright (C) Marcel de Kogel 1998
   e-mail: dekogel@giganda.komkon.org
   web: http://www.komkon.org/~dekogel

     You are not allowed to distribute this software commercially
     Please, notify me, if you make any changes to this file

   TExtOpenDialog and TExtOpenSaveDialog are similar to the standard
   TOpenDialog and TSaveDialog, but with the following differences:

   - The property EditFileStyle is not supported.
   - The properties HInstance, TemplateInt and TemplateString are added
     to support custom dialog box templates. If HInstance is 0, the
     application's handle is used.
   - The OnDialogMessage event is added. It is called whenever the
     dialog hook procedure gets called.
   - HistoryList is updated every time Execute() returns true
   - The property HistoryListSize is added. It can be used to limit the
     size of the HistoryList property to anywhere between 1 and 1000
     strings.
   - The propery DynamicChangeDefaultExt is added to support dynamic
     change of the default extension when the user selects a different
     file type. The default extension is set to the extension of the
     first filter extension, or is cleared when the first filter
     extension contains wildcards. Please note that Windows does not
     properly support default extensions larger than three characters
     (so use *.htm;*.html instead of *.html;*.htm).

   Revisions:
   1.0  14-09-1998   Initial release
*/
//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop
#include <dir.h>
#include <dsgnintf.hpp>
#include <filtedit.hpp>

#include "TExtOpenDialog.h"
//---------------------------------------------------------------------------
static inline TExtOpenDialog *ValidCtrCheck()
{
	return new TExtOpenDialog(NULL);
}
//---------------------------------------------------------------------------
static void SetDefaultExt(OPENFILENAME *pOFN)
{
}
//---------------------------------------------------------------------------
BOOL CALLBACK _export OpenFileHookProc
        (HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam)
{
 if (message==WM_INITDIALOG)
 {
  // Get a pointer to the TExtDialog object, and put it in the extra window bytes
  OPENFILENAME *ofn=(OPENFILENAME*)lParam;
  SetWindowLong(hwnd,GWL_USERDATA,ofn->lCustData);
 }
 // Get a pointer to the TExtOpenDialog object this window belongs to
 TExtOpenDialog *ExtOpenDialog=(TExtOpenDialog*)GetWindowLong(hwnd,GWL_USERDATA);
 // Prevent access violation if WM_INITDIALOG hasn't yet been processed
 if (!ExtOpenDialog) return 0;
 // If extension changed, and DynamicChangeDefaultExt is true, change default extension
 if (message==WM_NOTIFY)
 {
  OFNOTIFY *pofn=(OFNOTIFY*)lParam;
  if (pofn->hdr.code==CDN_TYPECHANGE || pofn->hdr.code==CDN_INITDONE)
  {
   if (ExtOpenDialog->DynamicChangeDefaultExt)
   {
    char *p=(char*)pofn->lpOFN->lpstrFilter;
    if (p && p[0])
    {
     for (int i=1;i<(int)pofn->lpOFN->nFilterIndex*2;++i)
     {
      p+=strlen(p)+1;
      if (p[0]=='\0') break;
     }
     p=strchr(p,'.');
     if (p && !strchr(p,'*') && !strchr(p,'?'))
     {
      char *q=(char*)pofn->lpOFN->lpstrDefExt;
      while (p[0] && p[0]!=';')
       *q++=*p++;
     }
    }
   }
  }
 }
 // Call the OnDialogMessage event
 if (ExtOpenDialog->OnDialogMessage)
 {
  MSG msg;
  msg.hwnd=hwnd;
  msg.message=message;
  msg.wParam=wParam;
  msg.lParam=lParam;
  msg.time=GetMessageTime();
  DWORD Pos=GetMessagePos();
  msg.pt.x=LOWORD(Pos);
  msg.pt.y=HIWORD(Pos);
  bool Handled=false;
  ExtOpenDialog->OnDialogMessage(ExtOpenDialog,msg,Handled);
  return Handled;
 }
 return 0;
}
//---------------------------------------------------------------------------
void __fastcall TExtOpenDialog::SetTemplateInt(unsigned short TemplateInt)
{
 FTemplateInt=TemplateInt;
 FTemplateString="";
}
//---------------------------------------------------------------------------
void __fastcall TExtOpenDialog::SetTemplateString(AnsiString TemplateString)
{
 FTemplateString=TemplateString;
 FTemplateInt=0;
}
//---------------------------------------------------------------------------
void __fastcall TExtOpenDialog::SetHInstance(int HInstance)
{
 FHInstance=HInstance;
}
//---------------------------------------------------------------------------
void __fastcall TExtOpenDialog::SetOnDialogMessage(TExtOpenDialogMessageEvent OnDialogMessage)
{
 FOnDialogMessage=OnDialogMessage;
}
//---------------------------------------------------------------------------
bool __fastcall TExtOpenDialog::OpenDialog(bool SaveDialog)
{
 OPENFILENAME ofn;
 char szFileName[MAXPATH*4];	// Support large multi-selections
 char DefExt[MAXEXT];
 memset(DefExt,'\0',sizeof(DefExt));
 memset(szFileName,'\0',sizeof(szFileName));
 strcpy (szFileName,FileName.c_str());
 memset(&ofn,0,sizeof(ofn));
 ofn.lStructSize=sizeof(OPENFILENAME);
 TForm *Form=NULL;
 try
 {
  Form=dynamic_cast<TForm*>(Owner);
 }
 catch (Exception &exception) {};
 ofn.hwndOwner=(Form)? Form->Handle : NULL;
 ofn.hInstance=(HINSTANCE)FHInstance;
 if (ofn.hInstance==NULL) ofn.hInstance=::HInstance;
 AnsiString TFilter=FFilter+"|";
 ofn.lpstrFilter=TFilter.c_str();
 char *p=(char*)ofn.lpstrFilter;
 while (p)
 {
  p=strchr(p,'|');
  if (p) *p++='\0';
 }
 ofn.lpstrCustomFilter=NULL;
 ofn.nMaxCustFilter=0;
 ofn.nFilterIndex=FFilterIndex;
 ofn.lpstrFile=szFileName;
 ofn.nMaxFile=sizeof(szFileName);
 ofn.lpstrFileTitle=NULL;
 ofn.nMaxFileTitle=0;
 if (FInitialDir.Length()) ofn.lpstrInitialDir=FInitialDir.c_str();
 if (FTitle.Length()) ofn.lpstrTitle=FTitle.c_str();
 ofn.nFileOffset=0;
 ofn.nFileExtension=0;
 strcpy (DefExt,FDefaultExt.c_str());
 ofn.lpstrDefExt=DefExt;
 ofn.lCustData=(DWORD)this;
 ofn.lpfnHook=(LPOFNHOOKPROC)OpenFileHookProc;
 TOpenOptions Opt=FOptions;
 ofn.Flags=OFN_ENABLEHOOK;
 if (Opt.Contains(ofReadOnly)) ofn.Flags|=OFN_READONLY;
 if (Opt.Contains(ofOverwritePrompt)) ofn.Flags|=OFN_OVERWRITEPROMPT;
 if (Opt.Contains(ofHideReadOnly)) ofn.Flags|=OFN_HIDEREADONLY;
 if (Opt.Contains(ofNoChangeDir)) ofn.Flags|=OFN_NOCHANGEDIR;
 if (Opt.Contains(ofShowHelp)) ofn.Flags|=OFN_SHOWHELP;
 if (Opt.Contains(ofNoValidate)) ofn.Flags|=OFN_NOVALIDATE;
 if (Opt.Contains(ofAllowMultiSelect)) ofn.Flags|=OFN_ALLOWMULTISELECT;
 if (Opt.Contains(ofExtensionDifferent)) ofn.Flags|=OFN_EXTENSIONDIFFERENT;
 if (Opt.Contains(ofPathMustExist)) ofn.Flags|=OFN_PATHMUSTEXIST;
 if (Opt.Contains(ofCreatePrompt)) ofn.Flags|=OFN_CREATEPROMPT;
 if (Opt.Contains(ofShareAware)) ofn.Flags|=OFN_SHAREAWARE;
 if (Opt.Contains(ofNoReadOnlyReturn)) ofn.Flags|=OFN_NOREADONLYRETURN;
 if (Opt.Contains(ofNoTestFileCreate)) ofn.Flags|=OFN_NOTESTFILECREATE;
 if (Opt.Contains(ofNoNetworkButton)) ofn.Flags|=OFN_NONETWORKBUTTON;
 if (Opt.Contains(ofNoLongNames)) ofn.Flags|=OFN_LONGNAMES;
 if (!Opt.Contains(ofOldStyleDialog)) ofn.Flags|=OFN_EXPLORER;
 if (Opt.Contains(ofNoDereferenceLinks)) ofn.Flags|=OFN_NODEREFERENCELINKS;
 if (FTemplateInt)
 {
  ofn.lpTemplateName=MAKEINTRESOURCE(FTemplateInt);
  ofn.Flags|=OFN_ENABLETEMPLATE;
 }
 if (FTemplateString!="")
 {
  ofn.lpTemplateName=FTemplateString.c_str();
  ofn.Flags|=OFN_ENABLETEMPLATE;
 }
 FFiles->Clear();
 if (!((SaveDialog)? GetSaveFileName(&ofn) : GetOpenFileName(&ofn))) return false;
 FFilterIndex=ofn.nFilterIndex;
 // Check multi selection
 if (ofn.Flags & OFN_ALLOWMULTISELECT)
 {
  // If we're using the old style dialog box, convert all spaces to '\0'
  if (!(ofn.Flags & OFN_EXPLORER))
  {
   char *p=szFileName;
   while (p)
   {
    p=strchr(p,' ');
    if (p) *p++='\0';
   }
  }
  FFileName=szFileName;	// If user selected more than one file, this is the path only
  p=szFileName+strlen(szFileName)+1;
  if (*p)
  {
   // If path doesn't end on a slash, add one
   if (FFileName.Length() && FFileName[FFileName.Length()-1]!='\\')
    FFileName+="\\";
   while (*p)
   {
    FFiles->Add(FFileName+p);
    p+=strlen(p)+1;
   }
   FileName=FFiles->Strings[0];
  }
  else
   FFiles->Add(FFileName);
 }
 else
 {
  FFileName=szFileName;
  FFiles->Add(FileName);
 }
 for (int n=0;n<FFiles->Count;++n)
 {
  bool AddFile=true;
  int i;
  for (i=0;i<FHistoryList->Count;++i)
  {
   if (FHistoryList->Strings[i]==FFiles->Strings[n])
   {
    AddFile=false;
    break;
   }
  }
  FHistoryList->Add(FFiles->Strings[n]);
  if (!AddFile) FHistoryList->Delete(i);
  if (FHistoryList->Count>FHistoryListSize) FHistoryList->Delete(0);
 }
 return true;
}
//---------------------------------------------------------------------------
bool __fastcall TExtOpenDialog::Execute(void)
{
 return OpenDialog(false);
}
//---------------------------------------------------------------------------
void __fastcall TExtOpenDialog::SetHistoryListSize(int HistoryListSize)
{
 if (HistoryListSize<1) HistoryListSize=1;
 if (HistoryListSize>1000) HistoryListSize=1000;
 FHistoryListSize=HistoryListSize;
 while (HistoryList->Count>HistoryListSize)
  HistoryList->Delete(0);
}
//---------------------------------------------------------------------------
void __fastcall TExtOpenDialog::SetDynamicChangeDefaultExt(bool DynamicChangeDefaultExt)
{
 FDynamicChangeDefaultExt=DynamicChangeDefaultExt;
}
//---------------------------------------------------------------------------
void __fastcall TExtOpenDialog::SetHistoryList(Classes::TStrings *HistoryList)
{
 FHistoryList->Assign(HistoryList);
 while (FHistoryList->Count>FHistoryListSize)
  FHistoryList->Delete(0);
}
//---------------------------------------------------------------------------
void __fastcall TExtOpenDialog::SetOptions(TOpenOptions Options)
{
 FOptions=Options;
}
//---------------------------------------------------------------------------
void __fastcall TExtOpenDialog::SetFilter(AnsiString Filter)
{
 FFilter=Filter;
}
//---------------------------------------------------------------------------
void __fastcall TExtOpenDialog::SetFilterIndex(int FilterIndex)
{
 FFilterIndex=FilterIndex;
}
//---------------------------------------------------------------------------
void __fastcall TExtOpenDialog::SetInitialDir(AnsiString InitialDir)
{
 FInitialDir=InitialDir;
}
//---------------------------------------------------------------------------
void __fastcall TExtOpenDialog::SetTitle(AnsiString Title)
{
 FTitle=Title;
}
//---------------------------------------------------------------------------
void __fastcall TExtOpenDialog::SetDefaultExt(AnsiString DefaultExt)
{
 FDefaultExt=DefaultExt;
}
//---------------------------------------------------------------------------
void __fastcall TExtOpenDialog::SetFileName(AnsiString FileName)
{
 FFileName=FileName;
}
//---------------------------------------------------------------------------
__fastcall TExtOpenDialog::TExtOpenDialog(TComponent* Owner)
	: TCommonDialog(Owner),
	  FTemplateInt(0),
	  FTemplateString(""),
      FHInstance(0),
      FOnDialogMessage(NULL),
      FDynamicChangeDefaultExt(false),
      FHistoryListSize(10),
      FFilter(""),
      FFilterIndex(1),
      FInitialDir(""),
      FTitle(""),
      FDefaultExt(""),
      FFileName("")
{
 FHistoryList=new TStringList;
 FHistoryList->Clear();
 FFiles=new TStringList;
 FFiles->Clear();
 Options.Clear();
}
//---------------------------------------------------------------------------
__fastcall TExtOpenDialog::~TExtOpenDialog()
{
 delete (TStringList*)FHistoryList;
 delete (TStringList*)FFiles;
}
//---------------------------------------------------------------------------
__fastcall TExtSaveDialog::TExtSaveDialog(TComponent* Owner)
	: TExtOpenDialog(Owner)
{
}
//---------------------------------------------------------------------------
bool __fastcall TExtSaveDialog::Execute(void)
{
 return OpenDialog(true);
}
//---------------------------------------------------------------------------
namespace Textopendialog
{
	void __fastcall Register()
	{
		TComponentClass classes[] = {__classid(TExtOpenDialog),
									 __classid(TExtSaveDialog)};
		RegisterComponents("MdK", classes, (sizeof(classes)/sizeof(classes[0])) - 1);
/* Can't get the typeinfo pointer of an AnsiString
		RegisterPropertyEditor(__typeinfo(AnsiString),
                         		__classid(TExtOpenDialog),
                         		"Filter",
                         		__classid(TFilterProperty));
*/
	}
}
//---------------------------------------------------------------------------

