/*
   Borland C++ Builder TExtOpenDialog and TExtSaveDialog components
   Version 1.0

   Copyright (C) Marcel de Kogel 1998
   e-mail: dekogel@giganda.komkon.org
   web: http://www.komkon.org/~dekogel

     You are not allowed to distribute this software commercially
     Please, notify me, if you make any changes to this file

   TExtOpenDialog and TExtOpenSaveDialog are similar to the standard
   TOpenDialog and TSaveDialog, but with the following differences:

   - The property EditFileStyle is not supported.
   - The properties HInstance, TemplateInt and TemplateString are added
     to support custom dialog box templates. If HInstance is 0, the
     application's handle is used.
   - The OnDialogMessage event is added. It is called whenever the
     dialog hook procedure gets called.
   - HistoryList is updated every time Execute() returns true
   - The property HistoryListSize is added. It can be used to limit the
     size of the HistoryList property to anywhere between 1 and 1000
     strings.
   - The propery DynamicChangeDefaultExt is added to support dynamic
     change of the default extension when the user selects a different
     file type. The default extension is set to the extension of the
     first filter extension, or is cleared when the first filter
     extension contains wildcards. Please note that Windows does not
     properly support default extensions larger than three characters
     (so use *.htm;*.html instead of *.html;*.htm).

   Revisions:
   1.0  14-09-1998   Initial release
*/
//---------------------------------------------------------------------------
#ifndef TExtOpenDialogH
#define TExtOpenDialogH
//---------------------------------------------------------------------------
#include <vcl\SysUtils.hpp>
#include <vcl\Controls.hpp>
#include <vcl\Classes.hpp>
#include <vcl\Forms.hpp>
#include <vcl\Dialogs.hpp>
//---------------------------------------------------------------------------
typedef void __fastcall (__closure *TExtOpenDialogMessageEvent)(TObject *Sender,tagMSG &Msg,bool &Handled);
//---------------------------------------------------------------------------
class TExtOpenDialog : public TCommonDialog
{
private:
	Classes::TStrings* FHistoryList;
	TOpenOptions FOptions;
	AnsiString FFilter;
	int FFilterIndex;
	AnsiString FInitialDir;
	AnsiString FTitle;
	AnsiString FDefaultExt;
	AnsiString FFileName;
	Classes::TStrings* FFiles;
    void __fastcall SetHistoryList(Classes::TStrings *HistoryList);
    void __fastcall SetOptions(TOpenOptions Options);
    void __fastcall SetFilter(AnsiString Filter);
    void __fastcall SetFilterIndex(int FilterIndex);
    void __fastcall SetInitialDir(AnsiString InitialDir);
    void __fastcall SetTitle(AnsiString Title);
    void __fastcall SetDefaultExt(AnsiString DefaultExt);
    void __fastcall SetFileName(AnsiString FileName);
	unsigned short FTemplateInt;
	bool FDynamicChangeDefaultExt;
	AnsiString FTemplateString;
    int FHInstance;
    TExtOpenDialogMessageEvent FOnDialogMessage;
    int FHistoryListSize;
    void __fastcall SetDynamicChangeDefaultExt(bool DynamicChangeDefaultExt);
	void __fastcall SetTemplateInt(unsigned short TemplateInt);
	void __fastcall SetTemplateString(AnsiString TemplateString);
	void __fastcall SetHInstance(int HInstance);
	void __fastcall SetOnDialogMessage(TExtOpenDialogMessageEvent OnDialogMessage);
    void __fastcall SetHistoryListSize(int HistoryListSize);
protected:
    bool __fastcall OpenDialog(bool SaveDialog);
public:
	__fastcall TExtOpenDialog(TComponent* Owner);
    __fastcall ~TExtOpenDialog();
    virtual bool __fastcall Execute(void);
    __property Classes::TStrings *Files = { read=FFiles };
__published:
	__property Classes::TStrings *HistoryList = { read=FHistoryList, write=SetHistoryList };
    __property TOpenOptions Options = { read=FOptions, write=SetOptions };
    __property AnsiString Filter = { read=FFilter, write=SetFilter };
    __property int FilterIndex = { read=FFilterIndex, write=SetFilterIndex };
    __property AnsiString InitialDir = { read=FInitialDir, write=SetInitialDir };
    __property AnsiString Title = { read=FTitle, write=SetTitle };
    __property AnsiString DefaultExt = { read=FDefaultExt, write=SetDefaultExt };
    __property AnsiString FileName = { read=FFileName, write=SetFileName };
	__property unsigned short TemplateInt = { read=FTemplateInt, write=SetTemplateInt };
	__property AnsiString TemplateString = { read=FTemplateString, write=SetTemplateString };
	__property int HInstance = { read=FHInstance, write=SetHInstance };
    __property TExtOpenDialogMessageEvent OnDialogMessage = { read=FOnDialogMessage, write=SetOnDialogMessage };
	__property bool DynamicChangeDefaultExt = { read=FDynamicChangeDefaultExt, write=SetDynamicChangeDefaultExt };
    __property int HistoryListSize = { read=FHistoryListSize, write=SetHistoryListSize };
};
//---------------------------------------------------------------------------
class TExtSaveDialog : public TExtOpenDialog
{
private:
protected:
public:
	__fastcall TExtSaveDialog(TComponent *Owner);
	virtual bool __fastcall Execute(void);
__published:
};
//---------------------------------------------------------------------------
#endif
